
import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';

class MiniButton extends StatelessWidget {
  final IconData icon;
  final Color color;
  final Color iconColor;
  final VoidCallback onTap;
  const MiniButton({super.key, required this.icon,this.color=Style.white,this.iconColor=Style.black, required this.onTap});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: 44,
        height: 44,
        decoration: BoxDecoration(
          color: color,
          borderRadius: BorderRadius.circular(AppConstants.radius),
          border: Border.all(color: Style.greyColor)
        ),
        child: Icon(icon,color: iconColor,size: 20,),
      ),
    );
  }
}
